/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.factories;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import java.util.Random;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.behaviour.plants.ShrubBehaviour;
import technology.rocketjump.undermount.entities.behaviour.plants.TreeBehaviour;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class PlantEntityFactory {
    private static final float MAX_POSITION_OFFSET = 0.2f;
    private static final float PLANT_RADIUS = 0.4f;
    private final MessageDispatcher messageDispatcher;
    private final EntityAssetUpdater entityAssetUpdater;

    @Inject
    public PlantEntityFactory(MessageDispatcher messageDispatcher, EntityAssetUpdater entityAssetUpdater) {
        this.messageDispatcher = messageDispatcher;
        this.entityAssetUpdater = entityAssetUpdater;
    }

    public Entity create(PlantEntityAttributes attributes, GridPoint2 tilePosition, TiledMap areaMap) {
        PhysicalEntityComponent physicalComponent = this.createPhysicalComponent(attributes);
        BehaviourComponent behaviorComponent = attributes.getSpecies().getPlantType().equals((Object)PlantSpeciesType.TREE) ? new TreeBehaviour() : new ShrubBehaviour();
        LocationComponent locationComponent = this.createLocationComponent(attributes, tilePosition);
        Entity entity = new Entity(EntityType.PLANT, physicalComponent, behaviorComponent, locationComponent, this.messageDispatcher, areaMap);
        this.entityAssetUpdater.updateEntityAssets(entity);
        return entity;
    }

    private LocationComponent createLocationComponent(PlantEntityAttributes attributes, GridPoint2 tilePosition) {
        RandomXS128 random = new RandomXS128(attributes.getSeed());
        LocationComponent locationComponent = new LocationComponent();
        Vector2 worldPosition = new Vector2((float)tilePosition.x + 0.5f, (float)tilePosition.y + 0.5f);
        worldPosition.x += ((Random)random).nextFloat() * 0.2f * 2.0f - 0.2f;
        worldPosition.y += ((Random)random).nextFloat() * 0.2f * 2.0f - 0.2f;
        locationComponent.setWorldPosition(worldPosition, false);
        locationComponent.setFacing(EntityAssetOrientation.DOWN.toVector2().cpy());
        locationComponent.setRadius(0.4f);
        return locationComponent;
    }

    private PhysicalEntityComponent createPhysicalComponent(PlantEntityAttributes attributes) {
        PhysicalEntityComponent physicalComponent = new PhysicalEntityComponent();
        physicalComponent.setAttributes(attributes);
        return physicalComponent;
    }
}

